#include "af901x.h"

DEVICE_CONTEXT DC;

int af901x_identify_state(struct usb_device *udev, struct dvb_usb_device_properties *props,
			struct dvb_usb_device_description **desc, int *cold)
{
	*cold = 0;

	return 0;
}

int af901x_download_firmware(struct usb_device *udev, const struct firmware *fw)
{
	int ret=0;
	deb_data("AF9015_download_firmware\n");

	
	return ret;
}


int af901x_powerctrl(struct dvb_usb_device *d, int onoff)
{

	int ret;
	deb_data("af9015_powerctrl- %s\n",onoff?"ON":"OFF");

	ret = DRV_TunerPowerCtrl(onoff);

	return ret;
}


int af901x_streaming_ctrl(struct dvb_usb_adapter *adap, int onoff)
{
	struct af901x_state *st = adap->dev->priv;

	deb_data("%s - (%d) streaming state for %d\n",__FUNCTION__,onoff, adap->id);

	if (onoff)
		st->channel_state |=   1 << adap->id;
	else
		st->channel_state &= ~(1 << adap->id);

	return 0;
}

static int af901x_probe(struct usb_interface *intf,
		const struct usb_device_id *id)
{
	int i;

	Afa901x_usb_init(interface_to_usbdev(intf),&DC);
		
	deb_data("AF9015_download_firmware\n");

	for (i = 0; i < af901x_device_count; i++)
		if (dvb_usb_device_init(intf, &af901x_devices[i], THIS_MODULE, NULL) == 0)
			return 0;

	return -ENODEV;
}

static struct usb_driver af901x_driver = {
#if LINUX_VERSION_CODE <=  KERNEL_VERSION(2,6,15)
	.owner = THIS_MODULE,
#endif
	.name       = "dvb_usb_af901x",
	.probe      = af901x_probe,
	.disconnect = dvb_usb_device_exit,
	.id_table   = af901x_usb_id_table,
};

static int __init af901x_module_init(void)
{
	int result;

	info("%s",__FUNCTION__);

	if ((result = usb_register(&af901x_driver))) {
		err("usb_register failed. Error number %d",result);
		return result;
	}
	return 0;
}

static void __exit af901x_module_exit(void)
{
	usb_deregister(&af901x_driver);
}

module_init (af901x_module_init);
module_exit (af901x_module_exit);

MODULE_AUTHOR("Rick Huang <rick_huang@afatech.com.tw>");
MODULE_DESCRIPTION("Driver for devices based on Afatech AF9015");
MODULE_VERSION("1.0");
MODULE_LICENSE("GPL");
